<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pricings', function (Blueprint $table) {
        $table->id();
        $table->string('name'); // e.g., Starter, Pro
        $table->string('price'); // e.g., $49
        $table->text('features'); // Features separated by comma
        $table->boolean('is_recommended')->default(0); // For highlighting
        $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pricings');
    }
};
