<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\Auth\LoginController;

// 1. Public Route (Home)
Route::get('/', [HomeController::class, 'index'])->name('home');

// ১. পাবলিক রাউট (সাবস্ক্রিপশন সেভ করার জন্য)
Route::post('/subscribe', [HomeController::class, 'subscribe'])->name('subscribe');

// 2. Authentication Routes
// Register false করা আছে, এবং logout মেথড ম্যানুয়ালি ডিফাইন করা হয়েছে
Auth::routes(['register' => false]);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

// 3. Admin Routes (Protected by Auth Middleware)
Route::middleware(['auth'])->prefix('admin')->group(function () {

    // Dashboard
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');

    // Hero Section Update
    Route::post('/hero-update', [AdminController::class, 'updateHero'])->name('admin.hero.update');

    // About Section Update
    Route::post('/about-update', [AdminController::class, 'updateAbout'])->name('admin.about.update');

    // Services CRUD
    Route::post('/service-store', [AdminController::class, 'storeService'])->name('admin.service.store');
    Route::get('/service-delete/{id}', [AdminController::class, 'deleteService'])->name('admin.service.delete');

    // Projects CRUD (এই লাইনটি মিসিং ছিল বলেই আপনার এরর আসছিল)
    Route::post('/project-store', [AdminController::class, 'storeProject'])->name('admin.project.store');
    Route::get('/project-delete/{id}', [AdminController::class, 'deleteProject'])->name('admin.project.delete');

    // Features CRUD
    Route::post('/feature-store', [AdminController::class, 'storeFeature'])->name('admin.feature.store');
    Route::get('/feature-delete/{id}', [AdminController::class, 'deleteFeature'])->name('admin.feature.delete');

    // FAQ CRUD
    Route::post('/faq-store', [AdminController::class, 'storeFaq'])->name('admin.faq.store');
    Route::get('/faq-delete/{id}', [AdminController::class, 'deleteFaq'])->name('admin.faq.delete');

    // Pricing Routes
    Route::post('/pricing-store', [AdminController::class, 'storePricing'])->name('admin.pricing.store');
    Route::get('/pricing-delete/{id}', [AdminController::class, 'deletePricing'])->name('admin.pricing.delete');

    Route::post('/contact-submit', [HomeController::class, 'storeContact'])->name('contact.submit');

    Route::post('/logo-update', [AdminController::class, 'updateLogo'])->name('admin.logo.update');

    Route::get('/subscriber-delete/{id}', [AdminController::class, 'deleteSubscriber'])->name('admin.subscriber.delete');
});
